using System;
using System.Reflection;
using System.Collections.Generic;
using System.Text;

namespace EventInfoDemo
{
   class Program
   {
      static void Main(string[] args)
      {
         ReflectMethods.Customer<string> cust = new ReflectMethods.Customer<string>();
         ReflectMethods.PropertyChangedDelegate propDel =
            new ReflectMethods.PropertyChangedDelegate(cust_OnPropertyChanged);
         cust.OnPropertyChanged += propDel;

         EventInfo evt = cust.GetType().GetEvent("OnPropertyChanged");
         Console.WriteLine("Zdarzenie {0}:", evt.Name);
         Console.WriteLine("\tZbiorowe?: {0}", evt.IsMulticast ? "Prawda" : "Fasz");
         Console.WriteLine("\tModu: {0}", evt.Module.Name);

         MethodInfo addMethod = evt.GetAddMethod();
         Console.WriteLine("\tAkcesor add: {0}", addMethod.ToString());
         Console.WriteLine("\tAkcesor remove: {0}", evt.GetRemoveMethod().ToString());

         cust.PubData = 99;

         evt.RemoveEventHandler(cust, propDel);
         cust.PubData = 42;

         evt.AddEventHandler(cust, propDel);
         evt.AddEventHandler(cust, propDel);
         cust.PubData = 150;

         Console.ReadLine();

      }

      static void cust_OnPropertyChanged(string propName, int value)
      {
         Console.WriteLine("Zmieniona wasno klienta: {0}, {1}", propName, value);
      }
   }
}
